package com.codingame.game;

import com.codingame.gameengine.module.entities.GraphicEntityModule;

import java.util.ArrayList;

public class Board {
    int[][]grid = new int[6][7];
    static GraphicEntityModule g;


    public boolean hasWon(int p) {
        int[][] dirs = {{0, -1}, {0, 1}, {-1, 0}, {1, 0}, {-1, -1}, {-1, 1}};
        for(int y = 0; y < Referee.HEIGHT; ++y) {
            for(int x = 0; x < Referee.WIDTH; ++x) {
                if(grid[y][x] != p) continue;

                for (int[] d: dirs) {
                    int count = 0;
                    int _y = y;
                    int _x  = x;
                    while(true) {
                        if(_y + d[0] < 0 || _y + d[0] >= Referee.HEIGHT) break;
                        if(_x + d[1] < 0 || _x + d[1] >= Referee.WIDTH) break;
                        if(grid[_y][_x] != p) break;
                        ++count;
                        _y += d[0];
                        _x += d[1];
                    }
                    if(count >= 4)
                        return true;
                }
            }
        }
        return false;
    }

    public ArrayList<Integer> getLegalMoves() {
        ArrayList<Integer> a = new ArrayList<>();
        for(int x = 0; x < Referee.WIDTH; ++x) {
            if(grid[0][x] != 0) continue;
            a.add(x);
        }
        return a;
    }

    public Board(GraphicEntityModule graphics) {
        this.g = graphics;
        g.createRectangle().setWidth(1920).setHeight(1080).setFillColor(0xC2C5CC);
        g.createRectangle().setWidth(Referee.WIDTH * 160).setHeight(Referee.HEIGHT * 160).setFillColor(0xFFFF00).setX(400).setY(100);

        for(int y = 0; y < Referee.HEIGHT; ++y) {
            for(int x = 0; x < Referee.WIDTH; ++x) {
                g.createCircle().setX(480+ 160 * x).setRadius(78).setY(180 + 160 * y).setFillColor(0xC2C5CC);
            }
        }
    }

    public boolean applyMove(int x, Player p) {
        int id = p.getIndex() + 1;
        if(grid[0][x] != 0) return false;

        int y = 0;
        while(grid[y + 1][x] == 0) {
            y++;
            if(y >= Referee.HEIGHT - 1)
                break;
        }
        grid[y][x] = id;
        System.err.println(grid[y][x]);
        g.createCircle().setX(480+ 160 * x).setRadius(78).setY(180 + 160 * y).setFillColor(p.getColorToken());
        return  true;
    }
}
