import { GraphicEntityModule } from './entity-module/GraphicEntityModule.js';
import { ToggleModule } from './toggle-module/ToggleModule.js';

export const gameName = 'Castle-Troll';

export const playerColors = [
  '#f2b213', // yellow
  '#22a1e4' // curious blue
];

export const modules = [
      GraphicEntityModule
    , ToggleModule
];

function ip_shuffle(array) {
    for (var i = array.length-1; i > 0; i--) {
        var s = Math.floor((i+1) * Math.random());
        var selected = array[s];
        array[s] = array[i];
        array[i] = selected;
    }
    return array;
}

function trollCase(string) {
    return string.split('')
        .map(c => Math.random() < 0.5 ? c.toUpperCase() : c.toLowerCase())
        .join('');
}

function trollToggle(toggle, title, def) {
    var obj = {};
    obj['toggle'] = toggle;
    obj['title'] = trollCase(title);
    obj['values'] = {};
    var indices = [];
    for (var i = 3; i < arguments.length; i += 2) indices.push(i);
    ip_shuffle(indices).forEach(i => obj['values'][trollCase(arguments[i])] = arguments[i+1]);
    obj['default'] = def;
    if (def == undefined) {
        if (obj['values'].length > 2) {
            obj['default'] = obj['values'].length * Math.floor(2 * Math.random());
        }
        else {
            obj['default'] = Math.random() < 0.5;
        }
    }
    return ToggleModule.defineToggle(obj);
}

function konamiToggle() {
    var t = trollToggle.apply(this, arguments);
    var sequence = [2, 2, 1, 1, 0, 3, 0, 3, 4, 5];
    var idx = 0;
    t.set = (value) => {
        if (value === sequence[idx]) {
            if (++idx >= sequence.length) {
                ToggleModule.toggles['troll'] = true;
                ToggleModule.refreshContent();
            }
        }
        else { idx = 0; }
    }
    return t;
}

export const options = ip_shuffle ([
    konamiToggle('troll', "Do not touch this", false,
                '←', 0, '↓', 1, '↑', 2, '→', 3, 'B', 4, 'A', 5),
    trollToggle('pants', 'pants', 1 + Math.floor(3 * Math.random()),
                'red', 1, 'green', 2, 'blue', 3, 'you perv', 4),
    trollToggle('verboseTrolling', 'Verbose Trolling', true,
                'on', true, 'off', false),
    trollToggle('debug', 'Detroll Mode', false,
                'on', true, 'off', false)
]);
